/*******************************************************
Filename		:  char_stn_table.sql
Release 		:  C2.0.1/E2.0
SIR			:  1365, 1553
Description		:  Characteristic station association/summary table.
Author			:  Ganesh Thadkamalla
Date			:  10/25/2002.
Comments		:  06/06/03 - Edited to SIR 1468. Updated tablespace_names. -Ganesh
                     07/17/03 - Added code for Biological taxon characteristics. -C Tsang
                     08/01/03 - Added code for Portable Data Logger. -C Tsang
			   09/02/03 - populate stn_visited column -JW
                     09/29/03 - SIR 1553- Updated to create separate counts for Regular, Biological, and Habitat results. -C Tsang
**********************************************************/

spool char_stn_table.log
connect storetw/storetw@storet.sdc
drop table station_char_temp;
create table station_char_temp
tablespace storetdata
storage (initial 10M next 5M) 
as 
select distinct ch.tsrchar_is_number fk_char, statn.pk_isn fk_fa_statn,
       ch.display_name,ch.search_name,ch.char_type_code,
       count(*) Regular_count
from storet1.tsrrsult rsult,
     storetw.fa_station statn,
     storet1.tsrstvst stvst,
     storet1.tsrfdact fdact,
     storet.tsrchar ch
where ch.tsrchar_is_Number= rsult.tsrchar_is_number
and ch.tsrchar_org_id = rsult.tsrchar_org_id
and rsult.tsrfdact_is_number = fdact.tsrfdact_is_number
and rsult.tsrfdact_org_id = fdact.tsrfdact_org_id
and fdact.tsrstvst_is_number = stvst.tsrstvst_is_number
and fdact.tsrstvst_org_id = stvst.tsrstvst_org_id
and stvst.tsmstatn_is_number = statn.station_is_number
and stvst.tsmstatn_org_id = statn.organization_id
AND RSULT.value_status ='F'                           -- added 07/17/03
and fdact.medium_type_name in ('Air','Sediment','Soil','Water','Other')  -- added 09/26/03 to exclude Biological
and fdact.type_name <> 'Data Logger'                                     --           and Habitat Assessment activities
group by ch.tsrchar_is_number, statn.pk_isn,
       ch.display_name,ch.search_name,ch.char_type_code;

alter table station_char_temp
add (Biological_count number, Habitat_count number);

-- Inserting Biological Individual/Tissue characteristics -- added 09/26/03
insert into station_char_temp(
       fk_char, fk_fa_statn,
       display_name, search_name, char_type_code, Biological_count)
select distinct ch.tsrchar_is_number fk_char, statn.pk_isn fk_fa_statn,
       ch.display_name,ch.search_name,ch.char_type_code,
       count(*) Biological_count
from storet1.tsrrsult rsult,
     storetw.fa_station statn,
     storet1.tsrstvst stvst,
     storet1.tsrfdact fdact,
     storet.tsrchar ch
where ch.tsrchar_is_Number= rsult.tsrchar_is_number
and ch.tsrchar_org_id = rsult.tsrchar_org_id
and rsult.tsrfdact_is_number = fdact.tsrfdact_is_number
and rsult.tsrfdact_org_id = fdact.tsrfdact_org_id
and fdact.tsrstvst_is_number = stvst.tsrstvst_is_number
and fdact.tsrstvst_org_id = stvst.tsrstvst_org_id
and stvst.tsmstatn_is_number = statn.station_is_number
and stvst.tsmstatn_org_id = statn.organization_id
AND RSULT.value_status ='F'                           
and fdact.medium_type_name = 'Biological'            
group by ch.tsrchar_is_number, statn.pk_isn,
       ch.display_name,ch.search_name,ch.char_type_code;
commit;

-- Inserting Habitat Assessment system-defined characteristics -- added 09/26/03
insert into station_char_temp(
       fk_char, fk_fa_statn,
       display_name, search_name, char_type_code, Habitat_count)
select distinct ch.tsrchar_is_number fk_char, statn.pk_isn fk_fa_statn,
       ch.display_name,ch.search_name,ch.char_type_code,
       count(*) Habitat_count
from storet1.tsrrsult rsult,
     storetw.fa_station statn,
     storet1.tsrstvst stvst,
     storet1.tsrfdact fdact,
     storet.tsrchar ch
where ch.tsrchar_is_Number= rsult.tsrchar_is_number
and ch.tsrchar_org_id = rsult.tsrchar_org_id
and rsult.tsrfdact_is_number = fdact.tsrfdact_is_number
and rsult.tsrfdact_org_id = fdact.tsrfdact_org_id
and fdact.tsrstvst_is_number = stvst.tsrstvst_is_number
and fdact.tsrstvst_org_id = stvst.tsrstvst_org_id
and stvst.tsmstatn_is_number = statn.station_is_number
and stvst.tsmstatn_org_id = statn.organization_id
AND RSULT.value_status ='F'                          
and fdact.category_type_name like '%Habitat%'     
group by ch.tsrchar_is_number, statn.pk_isn,
       ch.display_name,ch.search_name,ch.char_type_code;
commit;

-- Inserting Biological non-sti characteristics 
insert into station_char_temp(
       fk_char, fk_fa_statn,
       display_name, search_name, char_type_code, Biological_count)
select distinct ch.tsrchar_is_number fk_char, statn.pk_isn fk_fa_statn,
       ch.display_name,ch.search_name,ch.char_type_code,
       count(*) Biological_count
from storet1.tsrrsult rsult,
     storetw.fa_station statn,
     storet1.tsrstvst stvst,
     storet1.tsrfdact fdact,
     storet1.tsrbrg brg,
     storet.tsrchar ch
where ch.tsrchar_is_Number= rsult.tsrchar_is_number
and ch.tsrchar_org_id = rsult.tsrchar_org_id
and rsult.tsrbrg_is_number = brg.tsrbrg_is_number
and rsult.tsrbrg_org_id = brg.tsrbrg_org_id
and brg.tsrfdact_is_number = fdact.tsrfdact_is_number
and brg.tsrfdact_org_id = fdact.tsrfdact_org_id
and fdact.tsrstvst_is_number = stvst.tsrstvst_is_number
and fdact.tsrstvst_org_id = stvst.tsrstvst_org_id
and stvst.tsmstatn_is_number = statn.station_is_number
and stvst.tsmstatn_org_id = statn.organization_id
AND RSULT.value_status ='F'
AND fdact.medium_type_name = 'Biological'
group by ch.tsrchar_is_number, statn.pk_isn,
       ch.display_name,ch.search_name,ch.char_type_code;
commit;

-- Inserting Biological sti characteristics
insert into station_char_temp(
       fk_char, fk_fa_statn,
       display_name, search_name, char_type_code, Biological_count)
select distinct ch.tsrchar_is_number fk_char, statn.pk_isn fk_fa_statn,
       ch.display_name,ch.search_name,ch.char_type_code,
       count(*) Biological_count
from storet1.tsrrsult rsult,
     storetw.fa_station statn,
     storet1.tsrstvst stvst,
     storet1.tsrfdact fdact,
     storet1.tsrbrg brg,
     storet1.tsrbrgi brgi,
     storet.tsrchar ch
where ch.tsrchar_is_Number= rsult.tsrchar_is_number
and ch.tsrchar_org_id = rsult.tsrchar_org_id
and rsult.tsrbrgi_is_number = brgi.tsrbrgi_is_number
and rsult.tsrbrgi_org_id = brgi.tsrbrgi_org_id
and brgi.tsrbrg_is_number = brg.tsrbrg_is_number
and brgi.tsrbrg_org_id = brg.tsrbrg_org_id
and brg.tsrfdact_is_number = fdact.tsrfdact_is_number
and brg.tsrfdact_org_id = fdact.tsrfdact_org_id
and fdact.tsrstvst_is_number = stvst.tsrstvst_is_number
and fdact.tsrstvst_org_id = stvst.tsrstvst_org_id
and stvst.tsmstatn_is_number = statn.station_is_number
and stvst.tsmstatn_org_id = statn.organization_id
AND RSULT.value_status ='F'
AND fdact.medium_type_name = 'Biological'
group by ch.tsrchar_is_number, statn.pk_isn,
       ch.display_name,ch.search_name,ch.char_type_code;
commit;

-- Inserting Portable Data Logger characteristics
insert into station_char_temp(
       fk_char, fk_fa_statn,
       display_name, search_name, char_type_code, Regular_count)
select distinct ch.tsrchar_is_number fk_char, statn.pk_isn fk_fa_statn,
       ch.display_name,ch.search_name,ch.char_type_code,
       count(*) Regular_count
from storet1.tsrrsult rsult,
     storetw.fa_station statn,
     storet1.tsrstvst stvst,
     storet1.tsrfdact fdact,
     storet1.tsrdlin dlin,
     storet.tsrchar ch
where ch.tsrchar_is_Number= rsult.tsrchar_is_number
and ch.tsrchar_org_id = rsult.tsrchar_org_id
and rsult.tsrdlin_is_number = dlin.tsrdlin_is_number
and rsult.tsrdlin_org_id = dlin.tsrdlin_org_id
and dlin.tsrfdact_is_number = fdact.tsrfdact_is_number
and dlin.tsrfdact_org_id = fdact.tsrfdact_org_id
and fdact.tsrstvst_is_number = stvst.tsrstvst_is_number
and fdact.tsrstvst_org_id = stvst.tsrstvst_org_id
and stvst.tsmstatn_is_number = statn.station_is_number
and stvst.tsmstatn_org_id = statn.organization_id
AND RSULT.value_status ='F'
AND fdact.medium_type_name in ('Air','Sediment','Soil','Water','Other')
AND fdact.category_type_name = 'Portable Data Logger'
group by ch.tsrchar_is_number, statn.pk_isn,
       ch.display_name,ch.search_name,ch.char_type_code;
commit;

drop table station_char;
create table station_char unrecoverable 
tablespace storetdata
storage (initial 10M next 5M) 
as 
select distinct fk_char, fk_fa_statn,
       display_name, search_name, char_type_code, sum(Regular_count) regular_count, sum(Biological_count) biological_count,
       sum(Habitat_count) habitat_count 
from station_char_temp
group by fk_char, fk_fa_statn,
       display_name, search_name, char_type_code;
commit;

alter table station_char
add result_count number;

update station_char
set result_count = nvl(regular_count,0)+nvl(biological_count,0)+nvl(habitat_count,0);
commit;
 
alter table station_char
add constraint fk_station_char01 foreign key (FK_FA_STATN) references fa_station(pk_isn);

CREATE INDEX ICS_FK_CHAR ON STATION_CHAR(FK_CHAR)
TABLESPACE storetindx
STORAGE (INITIAL 2M NEXT 1M);

CREATE INDEX ICS_FK_FA_STATN ON STATION_CHAR(FK_FA_STATN)
TABLESPACE storetindx
STORAGE (INITIAL 2M NEXT 1M);

CREATE INDEX ICS_SEARCH_NAME ON STATION_CHAR(SEARCH_NAME)
TABLESPACE storetindx
STORAGE (INITIAL 2M NEXT 1M);

CREATE INDEX ICS_CHAR_TYPE_CODE ON STATION_CHAR(CHAR_TYPE_CODE)
TABLESPACE storetindx
STORAGE (INITIAL 2M NEXT 1M);
commit;

update fa_station set station_visited = 'YES'
where pk_isn in (select distinct(fk_fa_statn) from station_char);

commit;

/*
--delete taxa characteristic that do not have stations.
delete from di_characteristic c
where type_code='T'
and not exists (select 'x' from station_char sc
             where sc.FK_CHAR=c.pk_isn);
commit;
*/

spool off;